//=============================================================================
// EDG.
//=============================================================================
class TurdBomb extends ThrownProjectile;

var float	mpBlastRadius;
var float	mpProxRadius;
var float	mpLAMDamage;
var float	mpFuselength;

function PostBeginPlay()
{
  SetTimer(fuselength, False);

 Super.PostBeginPlay();
}

function Timer()
{
 Explode(Location, Normal(Velocity));
}

function SpawnTearGas()
{
	local Vector loc;
	local BioPoison gas;
	local int i;

	if ( Role < ROLE_Authority )
		return;

	for (i=0; i<blastRadius/24; i++)
	{
		if (FRand() < 0.9)
		{
			loc = Location;
			loc.X += FRand() * blastRadius - blastRadius * 0.5;
			loc.Y += FRand() * blastRadius - blastRadius * 0.5;
			loc.Z += 32;
			gas = spawn(class'BioPoison', None,, loc);
			if (gas != None)
			{
				gas.Velocity = vect(0,0,0);
				gas.Acceleration = vect(0,0,0);
				gas.DrawScale = FRand() * 0.5 + 1.0;
				gas.LifeSpan = FRand() * 10 + 4.75;
                                gas.damage = 65;
				if ( Level.NetMode != NM_Standalone )
					gas.bFloating = False;
				else
					gas.bFloating = True;
				gas.Instigator = Instigator;
			}
		}
	}
}


function PlayBeepSound( float Range, float Pitch, float volume )
{
	if ( Level.NetMode != NM_Standalone )
		PlaySound( sound'Fart',SLOT_None, volume,, Range, Pitch );
	else
		PlaySound( sound'Fart',SLOT_None,,, Range, Pitch );
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		proxRadius=mpProxRadius;
		Damage=mpLAMDamage;
		fuseLength=mpFuselength;
		bIgnoresNanoDefense=True;
	}
}

defaultproperties
{
     mpBlastRadius=512.000000
     mpProxRadius=128.000000
     mpLAMDamage=25.000000
     mpFuselength=1.500000
     fuseLength=3.000000
     proxRadius=160.000000
     DamageType=TearGas
     spawnWeaponClass=Class'MarkistanCity.WeaponEDG'
     ItemName="A Piece of Poop"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=50.000000
     MomentumTransfer=50000
     ImpactSound=Sound'DeusExSounds.Weapons.GasGrenadeExplode'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     LifeSpan=0.000000
     Mesh=LodMesh'Markistan.Turd'
     CollisionRadius=9.000000
     CollisionHeight=16.250000
     DrawScale=2.500000
     Mass=5.000000
     Buoyancy=2.000000
     MultiSkins(0)=Texture'GreenPoop'
     MultiSkins(1)=Texture'GreenPoop'
     MultiSkins(2)=Texture'GreenPoop'
     MultiSkins(3)=Texture'GreenPoop'
     MultiSkins(4)=Texture'GreenPoop'
     MultiSkins(5)=Texture'GreenPoop'
     MultiSkins(6)=Texture'GreenPoop'
     MultiSkins(7)=Texture'GreenPoop'
     MiscSound=None
}
